<?php

    if ( ! class_exists( 'Redux' ) ) {
        return;
    }

    // This is your option name where all the Redux data is stored.
    $opt_name = "sohohotel_data";

    $theme = wp_get_theme(); // For use with some settings. Not necessary.
	
    $args = array(   
        'opt_name'             => $opt_name,
        'display_name'         => $theme->get( 'Name' ),
        'display_version'      => $theme->get( 'Version' ),
        'menu_type'            => 'menu',
        'allow_sub_menu'       => false,
        'menu_title'           => esc_html__( 'Theme Options', 'soho-hotel' ),
        'page_title'           => esc_html__( 'Theme Options', 'soho-hotel' ),
        'google_api_key'       => '',
        'google_update_weekly' => false,
        'async_typography'     => true,
        'admin_bar'            => true,
        'admin_bar_icon'       => 'dashicons-portfolio',
        'admin_bar_priority'   => 50,
        'global_variable'      => '',
        'dev_mode'             => false,
        'update_notice'        => true,
        'customizer'           => true,
        'page_priority'        => null,
        'page_parent'          => 'themes.php',
        'page_permissions'     => 'manage_options',
        'menu_icon'            => '',
        'last_tab'             => '',
        'page_icon'            => 'icon-themes',
        'page_slug'            => '',
        'save_defaults'        => true,
        'default_show'         => false,
        'default_mark'         => '',
        'show_import_export'   => true,
        'transient_time'       => 60 * MINUTE_IN_SECONDS,
        'output'               => true,
        'output_tag'           => true,
        'database'             => '',
        'use_cdn'              => true,
        'hints'                => array(
            'icon'          => 'el el-question-sign',
            'icon_position' => 'right',
            'icon_color'    => 'lightgray',
            'icon_size'     => 'normal',
            'tip_style'     => array(
                'color'   => 'red',
                'shadow'  => true,
                'rounded' => false,
                'style'   => '',
            ),
            'tip_position'  => array(
                'my' => 'top left',
                'at' => 'bottom right',
            ),
            'tip_effect'    => array(
                'show' => array(
                    'effect'   => 'slide',
                    'duration' => '500',
                    'event'    => 'mouseover',
                ),
                'hide' => array(
                    'effect'   => 'slide',
                    'duration' => '500',
                    'event'    => 'click mouseleave',
                ),
            ),
        )
    );

    Redux::setArgs( $opt_name, $args );

    Redux::setSection( $opt_name, array(
        'title'            => esc_html__( 'General', 'soho-hotel' ),
        'id'               => 'general',
        'desc'             => '',
        'customizer_width' => '400px',
        'icon'             => 'el el-cog',
		'fields'           => array(
			array(
                'id'       => 'site-layout-style',
                'type'     => 'radio',
                'title'    => esc_html__( 'Site Default Layout Style', 'soho-hotel' ),
                'subtitle' => '',
                'desc'     => '',
                'options'  => array(
                    'right-sidebar' => 'Right Sidebar',
					'left-sidebar' => 'Left Sidebar',
                    'full-width' => 'Full Width'
                ),
                'default'  => 'right-sidebar'
            ),
			array(
				'id'       => 'background-layout-style',
				'type'     => 'radio',
				'title'    => esc_html__( 'Background Layout Style', 'soho-hotel' ),
				'subtitle' => '',
				'desc'     => '',
				'options'  => array(
					'boxed' => 'Boxed',
					'full-width' => 'Full Width'
				),
				'default'  => 'full-width'
			),
	        array(
	            'id'       => 'site-background-image',
	            'type'     => 'media',
	            'title'    => esc_html__( 'Site Background Image', 'soho-hotel' ),
	            'desc'     => esc_html__( 'Only visible if you have "Background Layout Style" set to "Boxed"', 'soho-hotel' ),
	            'subtitle' => '',
	        ),
			array(
				'id'       => 'site-header-style',
				'type'     => 'radio',
				'title'    => esc_html__( 'Header Style', 'soho-hotel' ),
				'subtitle' => '',
				'desc'     => '',
				'options'  => array(
					'sohohotel-header1' => 'Header 1',
					'sohohotel-header2' => 'Header 2',
					'sohohotel-header3' => 'Header 3',
					'sohohotel-header4' => 'Header 4',
					'sohohotel-header5' => 'Header 5',
					'sohohotel-header6' => 'Header 6',
				),
				'default'  => 'sohohotel-header1'
			),
			array(
                'id'       => 'top-right-menu',
                'type'     => 'checkbox',
                'title'    => esc_html__( 'Enable Top Right Menu For Language Selection', 'soho-hotel' ),
                'subtitle' => '',
                'desc'     => '',
                'default'  => '0'// 1 = on | 0 = off
            ),
			array(
                'id'       => 'top-left-phone',
                'type'     => 'text',
                'title'    => esc_html__( 'Top Left Phone Number', 'soho-hotel' ),
                'subtitle' => '',
                'desc'     => '',
                'default'  => '1111-2222-3333',
            ),
			array(
                'id'       => 'top-left-address',
                'type'     => 'text',
                'title'    => esc_html__( 'Top Left Address', 'soho-hotel' ),
                'subtitle' => '',
                'desc'     => '',
                'default'  => '55 Columbus Circle, New York, NY',
            ),
			array(
                'id'       => 'top-right-menu-text',
                'type'     => 'text',
                'title'    => esc_html__( 'Top Right Menu Text', 'soho-hotel' ),
                'subtitle' => '',
                'desc'     => '',
                'default'  => '',
            ),
			array(
                'id'       => 'top-right-button-text',
                'type'     => 'text',
                'title'    => esc_html__( 'Top Right Button Text', 'soho-hotel' ),
                'subtitle' => '',
                'desc'     => '',
                'default'  => 'Book Now',
            ),
			array(
                'id'       => 'top-right-button-url',
                'type'     => 'text',
                'title'    => esc_html__( 'Top Right Button URL', 'soho-hotel' ),
                'subtitle' => '',
                'desc'     => '',
                'default'  => '',
            ),
			array(
                'id'       => 'top-right-button-link-target',
                'type'     => 'checkbox',
                'title'    => esc_html__( 'Open top right button in new window/tab', 'soho-hotel' ),
                'subtitle' => '',
                'desc'     => '',
                'default'  => '0'// 1 = on | 0 = off
            ),
			array(
                'id'       => 'google-map-api-key',
                'type'     => 'text',
                'title'    => esc_html__( 'Google Map API Key', 'soho-hotel' ),
                'subtitle' => '',
                'desc'     => '',
                'default'  => '',
            ),
		)
	) );
	
		Redux::setSection( $opt_name, array(
		    'title'            => esc_html__( 'Bookings', 'soho-hotel' ),
		    'id'               => 'bookings',
		    'desc'             => '',
		    'customizer_width' => '400px',
		    'icon'             => 'el el-calendar',
			'fields'           => array(
				array(
	                'id'       => 'booking-email',
	                'type'     => 'text',
	                'title'    => esc_html__( 'Email Address', 'soho-hotel' ),
	                'subtitle' => '',
	                'desc'     => esc_html__( 'The email address booking notifications are sent to', 'soho-hotel' ),
	                'default'  => '',
	            ),
				array(
	                'id'       => 'email-sender-name',
	                'type'     => 'text',
	                'title'    => esc_html__( 'Email Sender Name', 'soho-hotel' ),
	                'subtitle' => '',
	                'desc'     => esc_html__( 'The name of the email sender booking notifications are send from', 'soho-hotel' ),
	                'default'  => 'Soho Hotel',
	            ),
				array(
	                'id'       => 'booking-phone',
	                'type'     => 'text',
	                'title'    => esc_html__( 'Phone Number', 'soho-hotel' ),
	                'subtitle' => '',
	                'desc'     => '',
	                'default'  => '',
	            ),
				array(
	                'id'       => 'booking-address',
	                'type'     => 'text',
	                'title'    => esc_html__( 'Address', 'soho-hotel' ),
	                'subtitle' => '',
	                'desc'     => '',
	                'default'  => '',
	            ),
				array(
				    'id'       => 'tax-rate',
				    'type'     => 'text',
				    'title'    => esc_html__( 'Tax added to total price (%)', 'soho-hotel' ),
	                'subtitle' => '',
	                'desc'     => esc_html__( 'Only add a number such as "10.5", do not add the percent (%) symbol', 'soho-hotel' ),
					'validate' => 'numeric',
				    'default'  => '0',
				),
				array(
				    'id'       => 'manually_confirm_bookings',
				    'type'     => 'checkbox',
				    'title'    => esc_html__( 'Manually Confirm Bookings', 'soho-hotel' ),
				    'subtitle' => '',
				    'desc'     => esc_html__( 'Availability of the room will not be blocked until the booking is manually confirmed', 'soho-hotel' ),
				    'default'  => '0'// 1 = on | 0 = off
				),
				array(
	                'id'       => 'remove_children_booking_form',
	                'type'     => 'checkbox',
	                'title'    => esc_html__( 'Remove Children From Booking Forms', 'soho-hotel' ),
	                'subtitle' => '',
	                'desc'     => '',
	                'default'  => '0'// 1 = on | 0 = off
	            ),
				array(
	                'id'       => 'booking_form_hotel',
	                'type'     => 'checkbox',
	                'title'    => esc_html__( 'Display "hotel/category" select option in booking forms', 'soho-hotel' ),
	                'subtitle' => '',
	                'desc'     => '',
	                'default'  => '0'// 1 = on | 0 = off
	            ),
				array(
				    'id'       => 'booking_show_remaining_rooms',
				    'type'     => 'select',
				    'title'    => __('Show the number of remaining rooms available when there are how many left?', 'soho-hotel'), 
				    'subtitle' => '',
				    'desc'     => '',
				    'options'  => array(
						'never' => 'Never',
						'1' => '1',
						'2' => '2',
						'3' => '3',
						'4' => '4',
						'5' => '5',
						'6' => '6',
						'7' => '7',
						'8' => '8',
						'9' => '9',
						'10' => '10',
						'11' => '11',
						'12' => '12',
						'13' => '13',
						'14' => '14',
						'15' => '15',
						'16' => '16',
						'17' => '17',
						'18' => '18',
						'19' => '19',
						'20' => '20',
						'21' => '21',
						'22' => '22',
						'23' => '23',
						'24' => '24',
						'25' => '25',
						'26' => '26',
						'27' => '27',
						'28' => '28',
						'29' => '29',
						'30' => '30'
				    ),
				    'default'  => '3',
				),
				array(
				    'id'       => 'booking_form_max_person',
				    'type'     => 'select',
				    'title'    => __('Maximum persons to show on booking form', 'soho-hotel'), 
				    'subtitle' => '',
				    'desc'     => '',
				    'options'  => array(
						'1' => '1',
						'2' => '2',
						'3' => '3',
						'4' => '4',
						'5' => '5',
						'6' => '6',
						'7' => '7',
						'8' => '8',
						'9' => '9',
						'10' => '10',
						'11' => '11',
						'12' => '12',
						'13' => '13',
						'14' => '14',
						'15' => '15',
						'16' => '16',
						'17' => '17',
						'18' => '18',
						'19' => '19',
						'20' => '20',
						'21' => '21',
						'22' => '22',
						'23' => '23',
						'24' => '24',
						'25' => '25',
						'26' => '26',
						'27' => '27',
						'28' => '28',
						'29' => '29',
						'30' => '30'
				    ),
				    'default'  => '5',
				),
				array(
				    'id'       => 'booking_form_max_rooms',
				    'type'     => 'select',
				    'title'    => __('Maximum rooms per booking', 'soho-hotel'), 
				    'subtitle' => '',
				    'desc'     => '',
				    'options'  => array(
						'1' => '1',
						'2' => '2',
						'3' => '3',
						'4' => '4',
						'5' => '5',
						'6' => '6',
						'7' => '7',
						'8' => '8',
						'9' => '9',
						'10' => '10',
						'11' => '11',
						'12' => '12',
						'13' => '13',
						'14' => '14',
						'15' => '15',
						'16' => '16',
						'17' => '17',
						'18' => '18',
						'19' => '19',
						'20' => '20',
						'21' => '21',
						'22' => '22',
						'23' => '23',
						'24' => '24',
						'25' => '25',
						'26' => '26',
						'27' => '27',
						'28' => '28',
						'29' => '29',
						'30' => '30'
				    ),
				    'default'  => '5',
				),
				array(
				    'id'       => 'minimum_stay',
				    'type'     => 'select',
				    'title'    => __('Minimum stay', 'soho-hotel'), 
				    'subtitle' => '',
				    'desc'     => '',
				    'options'  => array(
						'1' => '1 Night',
						'2' => '2 Nights',
						'3' => '3 Nights',
						'4' => '4 Nights',
						'5' => '5 Nights',
						'6' => '6 Nights',
						'7' => '7 Nights',
						'8' => '8 Nights',
						'9' => '9 Nights',
						'10' => '10 Nights',
						'11' => '11 Nights',
						'12' => '12 Nights',
						'13' => '13 Nights',
						'14' => '14 Nights',
						'15' => '15 Nights',
						'16' => '16 Nights',
						'17' => '17 Nights',
						'18' => '18 Nights',
						'19' => '19 Nights',
						'20' => '20 Nights',
						'21' => '21 Nights',
						'22' => '22 Nights',
						'23' => '23 Nights',
						'24' => '24 Nights',
						'25' => '25 Nights',
						'26' => '26 Nights',
						'27' => '27 Nights',
						'28' => '28 Nights',
						'29' => '29 Nights',
						'30' => '30 Nights',
						'30' => '31 Nights',
						'31' => '32 Nights',
						'32' => '33 Nights',
						'34' => '34 Nights',
						'35' => '35 Nights',
						'36' => '36 Nights',
						'37' => '37 Nights',
						'38' => '38 Nights',
						'39' => '39 Nights',
						'40' => '40 Nights',
						'41' => '41 Nights',
						'42' => '42 Nights',
						'43' => '43 Nights',
						'44' => '44 Nights',
						'45' => '45 Nights',
						'46' => '46 Nights',
						'47' => '47 Nights',
						'48' => '48 Nights',
						'49' => '49 Nights',
						'50' => '50 Nights',
						'51' => '51 Nights',
						'52' => '52 Nights',
						'53' => '53 Nights',
						'54' => '54 Nights',
						'55' => '55 Nights',
						'56' => '56 Nights',
						'57' => '57 Nights',
						'58' => '58 Nights',
						'59' => '59 Nights',
						'60' => '60 Nights',
						'61' => '61 Nights',
						'62' => '62 Nights',
						'63' => '63 Nights',
						'64' => '64 Nights',
						'65' => '65 Nights',
						'66' => '66 Nights',
						'67' => '67 Nights',
						'68' => '68 Nights',
						'69' => '69 Nights',
						'70' => '70 Nights',
						'70' => '71 Nights',
						'71' => '72 Nights',
						'72' => '73 Nights',
						'74' => '74 Nights',
						'75' => '75 Nights',
						'76' => '76 Nights',
						'77' => '77 Nights',
						'78' => '78 Nights',
						'79' => '79 Nights',
						'80' => '80 Nights',
						'81' => '81 Nights',
						'82' => '82 Nights',
						'83' => '83 Nights',
						'84' => '84 Nights',
						'85' => '85 Nights',
						'86' => '86 Nights',
						'87' => '87 Nights',
						'88' => '88 Nights',
						'89' => '89 Nights',
						'90' => '90 Nights',
						'91' => '91 Nights',
						'92' => '92 Nights',
						'93' => '93 Nights',
						'94' => '94 Nights',
						'95' => '95 Nights',
						'96' => '96 Nights',
						'97' => '97 Nights',
						'98' => '98 Nights',
						'99' => '99 Nights',
						'100' => '100 Nights'
				    ),
				    'default'  => '5',
				),
				array(
				    'id'       => 'date_format',
				    'type'     => 'select',
				    'title'    => __('Date format', 'soho-hotel'), 
				    'subtitle' => '',
				    'desc'     => '',
				    'options'  => array(
						'dd/mm/yy' => 'DD/MM/YYYY',
						'mm/dd/yy' => 'MM/DD/YYYY',
						'yy/mm/dd' => 'YYYY/MM/DD',
						'dd.mm.yy' => 'DD.MM.YYYY',
						'mm.dd.yy' => 'MM.DD.YYYY',
						'yy.mm.dd' => 'YYYY.MM.DD'
				    ),
				    'default'  => 'dd/mm/yy',
				),
				array(
				    'id'       => 'weekend_nights',
				    'type'     => 'select',
				    'title'    => __('Weekend Nights', 'soho-hotel'), 
				    'subtitle' => '',
				    'desc'     => __('Nights which use "weekend" prices', 'soho-hotel'),
				    'options'  => array(
						'1' => 'Fri/Sat',
						'2' => 'Sat/Sun',
						'3' => 'Thu/Fri/Sat',
						'4' => 'Fri/Sat/Sun'
					
				    ),
				    'default'  => '1',
				),
				array(
				    'id'       => 'weekly_booking_nights',
				    'type'     => 'select',
				    'title'    => __('Weekly Booking Nights', 'soho-hotel'), 
				    'subtitle' => '',
				    'desc'     => __('Number of nights a guest must book to qualify for "weekly" booking prices', 'soho-hotel'),
				    'options'  => array(
						'2' => '2 Nights',
						'3' => '3 Nights',
						'4' => '4 Nights',
						'5' => '5 Nights',
						'6' => '6 Nights',
						'7' => '7 Nights',
						'8' => '8 Nights',
						'9' => '9 Nights',
						'10' => '10 Nights',
						'11' => '11 Nights',
						'12' => '12 Nights',
						'13' => '13 Nights',
						'14' => '14 Nights',
						'15' => '15 Nights',
						'16' => '16 Nights',
						'17' => '17 Nights',
						'18' => '18 Nights',
						'19' => '19 Nights',
						'20' => '20 Nights',
						'21' => '21 Nights',
						'22' => '22 Nights',
						'23' => '23 Nights',
						'24' => '24 Nights',
						'25' => '25 Nights',
						'26' => '26 Nights',
						'27' => '27 Nights',
						'28' => '28 Nights',
						'29' => '29 Nights',
						'30' => '30 Nights',
						'30' => '31 Nights',
						'31' => '32 Nights',
						'32' => '33 Nights',
						'34' => '34 Nights',
						'35' => '35 Nights',
						'36' => '36 Nights',
						'37' => '37 Nights',
						'38' => '38 Nights',
						'39' => '39 Nights',
						'40' => '40 Nights',
						'41' => '41 Nights',
						'42' => '42 Nights',
						'43' => '43 Nights',
						'44' => '44 Nights',
						'45' => '45 Nights',
						'46' => '46 Nights',
						'47' => '47 Nights',
						'48' => '48 Nights',
						'49' => '49 Nights',
						'50' => '50 Nights',
						'51' => '51 Nights',
						'52' => '52 Nights',
						'53' => '53 Nights',
						'54' => '54 Nights',
						'55' => '55 Nights',
						'56' => '56 Nights',
						'57' => '57 Nights',
						'58' => '58 Nights',
						'59' => '59 Nights',
						'60' => '60 Nights',
						'61' => '61 Nights',
						'62' => '62 Nights',
						'63' => '63 Nights',
						'64' => '64 Nights',
						'65' => '65 Nights',
						'66' => '66 Nights',
						'67' => '67 Nights',
						'68' => '68 Nights',
						'69' => '69 Nights',
						'70' => '70 Nights',
						'70' => '71 Nights',
						'71' => '72 Nights',
						'72' => '73 Nights',
						'74' => '74 Nights',
						'75' => '75 Nights',
						'76' => '76 Nights',
						'77' => '77 Nights',
						'78' => '78 Nights',
						'79' => '79 Nights',
						'80' => '80 Nights',
						'81' => '81 Nights',
						'82' => '82 Nights',
						'83' => '83 Nights',
						'84' => '84 Nights',
						'85' => '85 Nights',
						'86' => '86 Nights',
						'87' => '87 Nights',
						'88' => '88 Nights',
						'89' => '89 Nights',
						'90' => '90 Nights',
						'91' => '91 Nights',
						'92' => '92 Nights',
						'93' => '93 Nights',
						'94' => '94 Nights',
						'95' => '95 Nights',
						'96' => '96 Nights',
						'97' => '97 Nights',
						'98' => '98 Nights',
						'99' => '99 Nights',
						'100' => '100 Nights'
				    ),
				    'default'  => '6',
				),
				array(
				    'id'       => 'monthly_booking_nights',
				    'type'     => 'select',
				    'title'    => __('Monthly Booking Nights', 'soho-hotel'), 
				    'subtitle' => '',
				    'desc'     => __('Number of nights a guest must book to qualify for "monthly" booking prices', 'soho-hotel'),
				    'options'  => array(
						'3' => '3 Nights',
						'4' => '4 Nights',
						'5' => '5 Nights',
						'6' => '6 Nights',
						'7' => '7 Nights',
						'8' => '8 Nights',
						'9' => '9 Nights',
						'10' => '10 Nights',
						'11' => '11 Nights',
						'12' => '12 Nights',
						'13' => '13 Nights',
						'14' => '14 Nights',
						'15' => '15 Nights',
						'16' => '16 Nights',
						'17' => '17 Nights',
						'18' => '18 Nights',
						'19' => '19 Nights',
						'20' => '20 Nights',
						'21' => '21 Nights',
						'22' => '22 Nights',
						'23' => '23 Nights',
						'24' => '24 Nights',
						'25' => '25 Nights',
						'26' => '26 Nights',
						'27' => '27 Nights',
						'28' => '28 Nights',
						'29' => '29 Nights',
						'30' => '30 Nights',
						'30' => '31 Nights',
						'31' => '32 Nights',
						'32' => '33 Nights',
						'34' => '34 Nights',
						'35' => '35 Nights',
						'36' => '36 Nights',
						'37' => '37 Nights',
						'38' => '38 Nights',
						'39' => '39 Nights',
						'40' => '40 Nights',
						'41' => '41 Nights',
						'42' => '42 Nights',
						'43' => '43 Nights',
						'44' => '44 Nights',
						'45' => '45 Nights',
						'46' => '46 Nights',
						'47' => '47 Nights',
						'48' => '48 Nights',
						'49' => '49 Nights',
						'50' => '50 Nights',
						'51' => '51 Nights',
						'52' => '52 Nights',
						'53' => '53 Nights',
						'54' => '54 Nights',
						'55' => '55 Nights',
						'56' => '56 Nights',
						'57' => '57 Nights',
						'58' => '58 Nights',
						'59' => '59 Nights',
						'60' => '60 Nights',
						'61' => '61 Nights',
						'62' => '62 Nights',
						'63' => '63 Nights',
						'64' => '64 Nights',
						'65' => '65 Nights',
						'66' => '66 Nights',
						'67' => '67 Nights',
						'68' => '68 Nights',
						'69' => '69 Nights',
						'70' => '70 Nights',
						'70' => '71 Nights',
						'71' => '72 Nights',
						'72' => '73 Nights',
						'74' => '74 Nights',
						'75' => '75 Nights',
						'76' => '76 Nights',
						'77' => '77 Nights',
						'78' => '78 Nights',
						'79' => '79 Nights',
						'80' => '80 Nights',
						'81' => '81 Nights',
						'82' => '82 Nights',
						'83' => '83 Nights',
						'84' => '84 Nights',
						'85' => '85 Nights',
						'86' => '86 Nights',
						'87' => '87 Nights',
						'88' => '88 Nights',
						'89' => '89 Nights',
						'90' => '90 Nights',
						'91' => '91 Nights',
						'92' => '92 Nights',
						'93' => '93 Nights',
						'94' => '94 Nights',
						'95' => '95 Nights',
						'96' => '96 Nights',
						'97' => '97 Nights',
						'98' => '98 Nights',
						'99' => '99 Nights',
						'100' => '100 Nights'
				    ),
				    'default'  => '28',
				),
				array(
	                'id'       => 'booking_page_url',
	                'type'     => 'text',
	                'title'    => esc_html__( 'Booking Page URL', 'soho-hotel' ),
	                'subtitle' => '',
	                'desc'     => esc_html__( 'Please enter page URL in a valid format e.g. http://website.com/page', 'soho-hotel' ),
	                'default'  => '',
	            ),
				array(
	                'id'       => 'currency_unit',
	                'type'     => 'text',
	                'title'    => esc_html__( 'Currency symbol', 'soho-hotel' ),
	                'subtitle' => '',
	                'desc'     => esc_html__( 'e.g. &#36;, &pound;, &euro;, &yen;, USD', 'soho-hotel' ),
	                'default'  => '$',
	            ),
				array(
	                'id'       => 'currency_position',
	                'type'     => 'checkbox',
	                'title'    => esc_html__( 'Currency symbol position', 'soho-hotel' ),
	                'subtitle' => '',
	                'desc'     => esc_html__( 'Display currency symbol right of the price', 'soho-hotel' ),
	                'default'  => '0'// 1 = on | 0 = off
	            ),
				array(
	                'id'       => 'price_thousand_separator',
	                'type'     => 'text',
	                'title'    => esc_html__( 'Price Thousand Separator', 'soho-hotel' ),
	                'subtitle' => '',
	                'desc'     => '',
	                'default'  => ',',
	            ),
				array(
	                'id'       => 'price_decimal_separator',
	                'type'     => 'text',
	                'title'    => esc_html__( 'Price Decimal Separator', 'soho-hotel' ),
	                'subtitle' => '',
	                'desc'     => '',
	                'default'  => '.',
	            ),
				array(
				    'id'       => 'price_decimal_places',
				    'type'     => 'select',
				    'title'    => __('Price Decimal Places', 'soho-hotel'), 
				    'subtitle' => '',
				    'desc'     => '',
				    'options'  => array(
						'zero' => '0',
						'1' => '1',
						'2' => '2',
						'3' => '3',
						'4' => '4',
						'5' => '5',
						'6' => '6',
						'7' => '7',
						'8' => '8',
						'9' => '9',
						'10' => '10'
				    ),
				    'default'  => '2',
				),
				array(
				    'id'       => 'deposit_type',
				    'type'     => 'select',
				    'title'    => __('Deposit Type', 'soho-hotel'), 
				    'subtitle' => '',
				    'desc'     => '',
				    'options'  => array(
						'1' => __('Percentage', 'soho-hotel'),
						'2' => __('Flat Rate', 'soho-hotel')
				    ),
				    'default'  => '1',
				),
				array(
				    'id'       => 'deposit_percentage',
				    'type'     => 'select',
				    'title'    => __('Deposit Percentage (%)', 'soho-hotel'), 
				    'subtitle' => '',
				    'desc'     => '',
				    'options'  => array(
						'1' => '1%',
						'2' => '2%',
						'3' => '3%',
						'4' => '4%',
						'5' => '5%',
						'6' => '6%',
						'7' => '7%',
						'8' => '8%',
						'9' => '9%',
						'10' => '10%',
						'11' => '11%',
						'12' => '12%',
						'13' => '13%',
						'14' => '14%',
						'15' => '15%',
						'16' => '16%',
						'17' => '17%',
						'18' => '18%',
						'19' => '19%',
						'20' => '20%',
						'21' => '21%',
						'22' => '22%',
						'23' => '23%',
						'24' => '24%',
						'25' => '25%',
						'26' => '26%',
						'27' => '27%',
						'28' => '28%',
						'29' => '29%',
						'30' => '30%',
						'31' => '31%',
						'32' => '32%',
						'33' => '33%',
						'34' => '34%',
						'35' => '35%',
						'36' => '36%',
						'37' => '37%',
						'38' => '38%',
						'39' => '39%',
						'40' => '40%',
						'41' => '41%',
						'42' => '42%',
						'43' => '43%',
						'44' => '44%',
						'45' => '45%',
						'46' => '46%',
						'47' => '47%',
						'48' => '48%',
						'49' => '49%',
						'50' => '50%',
						'51' => '51%',
						'52' => '52%',
						'53' => '53%',
						'54' => '54%',
						'55' => '55%',
						'56' => '56%',
						'57' => '57%',
						'58' => '58%',
						'59' => '59%',
						'60' => '60%',
						'61' => '61%',
						'62' => '62%',
						'63' => '63%',
						'64' => '64%',
						'65' => '65%',
						'66' => '66%',
						'67' => '67%',
						'68' => '68%',
						'69' => '69%',
						'70' => '70%',
						'71' => '71%',
						'72' => '72%',
						'73' => '73%',
						'74' => '74%',
						'75' => '75%',
						'76' => '76%',
						'77' => '77%',
						'78' => '78%',
						'79' => '79%',
						'80' => '80%',
						'81' => '81%',
						'82' => '82%',
						'83' => '83%',
						'84' => '84%',
						'85' => '85%',
						'86' => '86%',
						'87' => '87%',
						'88' => '88%',
						'89' => '89%',
						'90' => '90%',
						'91' => '91%',
						'92' => '92%',
						'93' => '93%',
						'94' => '94%',
						'95' => '95%',
						'96' => '96%',
						'97' => '97%',
						'98' => '98%',
						'99' => '99%',
						'100' => '100%'
				    ),
				    'default'  => '25',
				),
				array(
	                'id'       => 'deposit_flat_rate',
	                'type'     => 'text',
	                'title'    => esc_html__( 'Deposit Flat Rate', 'soho-hotel' ),
	                'subtitle' => '',
	                'desc'     => esc_html__( 'Add a number value only, do not add any currency symbol', 'soho-hotel' ),
	                'default'  => '',
					'validate' => 'numeric',
	            ),
				array(
	                'id'       => 'booking_success_message',
	                'type'     => 'textarea',
	                'title'    => esc_html__( 'Booking success message', 'soho-hotel' ),
	                'subtitle' => '',
	                'desc'     => '',
	                'default'  => 'Details of your reservation have just been sent to you in a confirmation email, we look forward to seeing you soon. In the meantime if you have any questions feel free to contact us.',
	            ),
				array(
	                'id'       => 'payment_success_message',
	                'type'     => 'textarea',
	                'title'    => esc_html__( 'Payment success message', 'soho-hotel' ),
	                'subtitle' => '',
	                'desc'     => '',
	                'default'  => 'Your payment has been received, we look forward to seeing you soon!',
	            ),
				array(
	                'id'       => 'terms_conditions',
	                'type'     => 'textarea',
	                'title'    => esc_html__( 'Terms and conditions', 'soho-hotel' ),
	                'subtitle' => '',
	                'desc'     => '',
	                'default'  => '',
	            ),
				array(
	                'id'       => 'booking_email_subject_guest',
	                'type'     => 'text',
	                'title'    => esc_html__( 'Guest confirmation email subject', 'soho-hotel' ),
	                'subtitle' => '',
	                'desc'     => '',
	                'default'  => 'Soho Hotel Booking Confirmation',
	            ),
				array(
	                'id'       => 'booking_email_content_guest',
	                'type'     => 'textarea',
	                'title'    => esc_html__( 'Guest confirmation email message', 'soho-hotel' ),
	                'subtitle' => '',
	                'desc'     => esc_html__( 'Sent to the guest when they place a booking', 'soho-hotel' ),
	                'default'  => 'Thanks for booking with Soho Hotel, we look forward to seeing you soon! If you have any questions please don\'t hesitate to get in touch.',
	            ),
				array(
	                'id'       => 'booking_email_subject_admin',
	                'type'     => 'text',
	                'title'    => esc_html__( 'Admin confirmation email subject', 'soho-hotel' ),
	                'subtitle' => '',
	                'desc'     => '',
	                'default'  => 'Soho Hotel New Booking Received',
	            ),
				array(
	                'id'       => 'booking_email_content_admin',
	                'type'     => 'textarea',
	                'title'    => esc_html__( 'Admin confirmation email message', 'soho-hotel' ),
	                'subtitle' => '',
	                'desc'     => esc_html__( 'Sent to the admin when a guest places a booking', 'soho-hotel' ),
	                'default'  => 'A new booking has been placed, please see below for details',
	            ),
				array(
	                'id'       => 'custom_booking_form',
	                'type'     => 'textarea',
	                'title'    => esc_html__( 'Custom Booking Form Fields', 'soho-hotel' ),
	                'subtitle' => '',
	                'desc'     => esc_html__( 'Used for the booking form on booking step 3 where guests enter their details', 'soho-hotel' ),
	                'default'  => '<div class="input-field-one-half">
	[text required id="first_name" label="First Name"]
	</div>

	<div class="input-field-one-half last-col">
	[text required id="last_name" label="Last Name"]
	</div>

	<div class="input-field-one-half">
	[text required id="email_address" class="email_validation" label="Email Address"]
	</div>

	<div class="input-field-one-half last-col">
	[text required id="telephone" class="number_validation" label="Telephone"]
	</div>

	<div class="input-field-one-half">
	[text required id="address_line_1" label="Address Line 1"]
	</div>

	<div class="input-field-one-half last-col">
	[text required id="address_line_2" label="Address Line 2"]
	</div>

	<div class="input-field-one-half">
	[text required id="city" label="City"]
	</div>

	<div class="input-field-one-half last-col">
	[text required id="state" label="State / County"]
	</div>

	<div class="input-field-one-half">
	[text required id="zip" label="Zip / Postcode"]
	</div>

	<div class="input-field-one-half last-col">
	[text required id="country" label="Country"]
	</div>

	<div class="clearboth"></div>
	[textarea required id="special_requirements" label="Special Requirements"]',
	        ),
			array(
			    'id'       => 'datepicker_days',
			    'type'     => 'textarea',
			    'title'    => esc_html__( 'Datepicker Days', 'soho-hotel' ),
			    'subtitle' => '',
			    'desc'     => esc_html__( 'Do not remove any of the quotemarks, commas or brackets when editing!', 'soho-hotel' ),
			    'default'  => "['Su', 'Mo', 'Tu', 'We', 'Th', 'Fr', 'Sa']",
			),
			array(
			    'id'       => 'datepicker_months',
			    'type'     => 'textarea',
			    'title'    => esc_html__( 'Datepicker Months', 'soho-hotel' ),
			    'subtitle' => '',
			    'desc'     => esc_html__( 'Do not remove any of the quotemarks, commas or brackets when editing!', 'soho-hotel' ),
			    'default'  => "['January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December']",
			)
		    )

		) );
	
		Redux::setSection( $opt_name, array(
		    'title'            => esc_html__( 'iCal', 'soho-hotel' ),
		    'id'               => 'iCal',
		    'desc'             => '',
		    'customizer_width' => '400px',
		    'icon'             => 'el el-repeat',
			'fields'           => array(
				array(
	                'id'       => 'refresh_ical',
	                'type'     => 'info',
	                'title'    => esc_html__( 'Manually Refresh iCal Feeds', 'soho-hotel' ),
	                'subtitle' => '',
	                'desc'     => esc_html__( 'You can manually refresh all iCal feeds by clicking here: ', 'soho-hotel' ) . '<a target="_blank" href="' . get_site_url() . '/?sh_ical=sync_all">' . get_site_url() . '/?sh_ical=sync_all</a>',
	            ),
				array(
	                'id'       => 'auto_refresh_ical',
	                'type'     => 'info',
	                'title'    => esc_html__( 'Auto Refresh iCal Feeds', 'soho-hotel' ),
	                'subtitle' => '',
	                'desc'     => esc_html__( 'To auto refresh iCal feeds you should setup a cron job in your web hosting control panel, the command you should run is: wget ' . get_site_url() . '/?sh_ical=sync_all', 'soho-hotel' ),
	            )
		    )

		) );
	
		Redux::setSection( $opt_name, array(
		    'title'            => esc_html__( 'PayPal', 'soho-hotel' ),
		    'id'               => 'paypal',
		    'desc'             => '',
		    'customizer_width' => '400px',
		    'icon'             => 'el el-credit-card',
			'fields'           => array(
				array(
	                'id'       => 'disable_paypal',
	                'type'     => 'checkbox',
	                'title'    => esc_html__( 'Disable PayPal', 'soho-hotel' ),
	                'subtitle' => '',
	                'desc'     => esc_html__( 'If you check this option PayPal payments will not be available to guests', 'soho-hotel' ),
	                'default'  => '0'// 1 = on | 0 = off
	            ),
				array(
				    'id'       => 'paypal-currency',
				    'type'     => 'select',
				    'title'    => __('PayPal Currency', 'soho-hotel'), 
				    'subtitle' => '',
				    'desc'     => esc_html__( 'The currency PayPal payments will be process with', 'soho-hotel' ),
				    'options'  => array(
				        'AUD' => 'AUD (Australian Dollar)',
						'BRL' => 'BRL (Brazilian Real)',
						'CAD' => 'CAD (Canadian Dollar)',
						'CZK' => 'CZK (Czech Koruna)',
						'DKK' => 'DKK (Danish Krone)',
						'EUR' => 'EUR (Euro)',
						'HKD' => 'HKD (Hong Kong Dollar)',
						'HUF' => 'HUF (Hungarian Forint)',
						'ILS' => 'ILS (Israeli New Sheqel)',
						'INR' => 'INR (Indian Rupee)',
						'JPY' => 'JPY (Japanese Yen)',
						'MYR' => 'MYR (Malaysian Ringgit)',
						'MXN' => 'MXN (Mexican Peso)',
						'NOK' => 'NOK (Norwegian Krone)',
						'NZD' => 'NZD (New Zealand Dollar)',
						'PHP' => 'PHP (Philippine Peso)',
						'PLN' => 'PLN (Polish Zloty)',
						'GBP' => 'GBP (Pound Sterling)',
						'RUB' => 'RUB (Russian Ruble)',
						'SGD' => 'SGD (Singapore Dollar)',
						'SEK' => 'SEK (Swedish Krona)',
						'CHF' => 'CHF (Swiss Franc)',
						'TWD' => 'TWD (Taiwan New Dollar)',
						'THB' => 'THB (Thai Baht)',
						'USD' => 'USD (U.S. Dollar)'
				    ),
				    'default'  => 'USD',
				),
				array(
				    'id'       => 'paypal-sandbox',
				    'type'     => 'select',
				    'title'    => __('PayPal Sandbox', 'soho-hotel'), 
				    'subtitle' => '',
				    'desc'     => esc_html__( 'PayPal sandbox allows you to test payments - you should set it to off when you publish your website', 'soho-hotel' ),
				    'options'  => array(
				        'true' => 'On',
						'false' => 'Off'
				    ),
				    'false'  => 'Off',
				),
				array(
		            'id'       => 'paypal-address',
		            'type'     => 'text',
		            'title'    => esc_html__( 'PayPal Email Address', 'soho-hotel' ),
		            'subtitle' => '',
		            'desc'     => esc_html__( 'The email address PayPal payments will be sent to', 'soho-hotel' ),
		            'default'  => '',
		        )
		    )

		) );
	
		Redux::setSection( $opt_name, array(
		    'title'            => esc_html__( 'Stripe', 'soho-hotel' ),
		    'id'               => 'stripe',
		    'desc'             => '',
		    'customizer_width' => '400px',
		    'icon'             => 'el el-credit-card',
			'fields'           => array(
				array(
	                'id'       => 'disable_stripe',
	                'type'     => 'checkbox',
	                'title'    => esc_html__( 'Disable Stripe', 'soho-hotel' ),
	                'subtitle' => '',
	                'desc'     => esc_html__( 'If you check this option Stripe/credit card payments will not be available to guests', 'soho-hotel' ),
	                'default'  => '0'// 1 = on | 0 = off
	            ),
				array(
				    'id'       => 'stripe-currency',
				    'type'     => 'select',
				    'title'    => __('Stripe Currency', 'soho-hotel'), 
				    'subtitle' => '',
				    'desc'     => esc_html__( 'The currency Stripe payments will be process with', 'soho-hotel' ),
				    'options'  => array(
				        'AED' => 'United Arab Emirates Dirham',
						'AFN' => 'Afghan Afghani',
						'ALL' => 'Albanian Lek',
						'AMD' => 'Armenian Dram',
						'ANG' => 'Netherlands Antillean Gulden',
						'AOA' => 'Angolan Kwanza',
						'ARS' => 'Argentine Peso',
						'AUD' => 'Australian Dollar',
						'AWG' => 'Aruban Florin',
						'AZN' => 'Azerbaijani Manat',
						'BAM' => 'Bosnia & Herzegovina Convertible Mark',
						'BBD' => 'Barbadian Dollar',
						'BDT' => 'Bangladeshi Taka',
						'BGN' => 'Bulgarian Lev',
						'BIF' => 'Burundian Franc',
						'BMD' => 'Bermudian Dollar',
						'BND' => 'Brunei Dollar',
						'BOB' => 'Bolivian Boliviano',
						'BRL' => 'Brazilian Real',
						'BSD' => 'Bahamian Dollar',
						'BWP' => 'Botswana Pula',
						'BZD' => 'Belize Dollar',
						'CAD' => 'Canadian Dollar',
						'CDF' => 'Congolese Franc',
						'CHF' => 'Swiss Franc',
						'CLP' => 'Chilean Peso',
						'CNY' => 'Chinese Renminbi Yuan',
						'COP' => 'Colombian Peso',
						'CRC' => 'Costa Rican Colón',
						'CVE' => 'Cape Verdean Escudo',
						'CZK' => 'Czech Koruna',
						'DJF' => 'Djiboutian Franc',
						'DKK' => 'Danish Krone',
						'DOP' => 'Dominican Peso',
						'DZD' => 'Algerian Dinar',
						'EGP' => 'Egyptian Pound',
						'ETB' => 'Ethiopian Birr',
						'EUR' => 'Euro',
						'FJD' => 'Fijian Dollar',
						'FKP' => 'Falkland Islands Pound',
						'GBP' => 'British Pound',
						'GEL' => 'Georgian Lari',
						'GIP' => 'Gibraltar Pound',
						'GMD' => 'Gambian Dalasi',
						'GNF' => 'Guinean Franc',
						'GTQ' => 'Guatemalan Quetzal',
						'GYD' => 'Guyanese Dollar',
						'HKD' => 'Hong Kong Dollar',
						'HNL' => 'Honduran Lempira',
						'HRK' => 'Croatian Kuna',
						'HTG' => 'Haitian Gourde',
						'HUF' => 'Hungarian Forint',
						'IDR' => 'Indonesian Rupiah',
						'ILS' => 'Israeli New Sheqel',
						'INR' => 'Indian Rupee',
						'ISK' => 'Icelandic Króna',
						'JMD' => 'Jamaican Dollar',
						'JPY' => 'Japanese Yen',
						'KES' => 'Kenyan Shilling',
						'KGS' => 'Kyrgyzstani Som',
						'KHR' => 'Cambodian Riel',
						'KMF' => 'Comorian Franc',
						'KRW' => 'South Korean Won',
						'KYD' => 'Cayman Islands Dollar',
						'KZT' => 'Kazakhstani Tenge',
						'LAK' => 'Lao Kip',
						'LBP' => 'Lebanese Pound',
						'LKR' => 'Sri Lankan Rupee',
						'LRD' => 'Liberian Dollar',
						'LSL' => 'Lesotho Loti',
						'MAD' => 'Moroccan Dirham',
						'MDL' => 'Moldovan Leu',
						'MGA' => 'Malagasy Ariary',
						'MKD' => 'Macedonian Denar',
						'MMK' => 'Myanmar Kyat',
						'MNT' => 'Mongolian Tögrög',
						'MOP' => 'Macanese Pataca',
						'MRO' => 'Mauritanian Ouguiya',
						'MUR' => 'Mauritian Rupee',
						'MVR' => 'Maldivian Rufiyaa',
						'MWK' => 'Malawian Kwacha',
						'MXN' => 'Mexican Peso',
						'MYR' => 'Malaysian Ringgit',
						'MZN' => 'Mozambican Metical',
						'NAD' => 'Namibian Dollar',
						'NGN' => 'Nigerian Naira',
						'NIO' => 'Nicaraguan Córdoba',
						'NOK' => 'Norwegian Krone',
						'NPR' => 'Nepalese Rupee',
						'NZD' => 'New Zealand Dollar',
						'PAB' => 'Panamanian Balboa',
						'PEN' => 'Peruvian Nuevo Sol',
						'PGK' => 'Papua New Guinean Kina',
						'PHP' => 'Philippine Peso',
						'PKR' => 'Pakistani Rupee',
						'PLN' => 'Polish Złoty',
						'PYG' => 'Paraguayan Guaraní',
						'QAR' => 'Qatari Riyal',
						'RON' => 'Romanian Leu',
						'RSD' => 'Serbian Dinar',
						'RUB' => 'Russian Ruble',
						'RWF' => 'Rwandan Franc',
						'SAR' => 'Saudi Riyal',
						'SBD' => 'Solomon Islands Dollar',
						'SCR' => 'Seychellois Rupee',
						'SEK' => 'Swedish Krona',
						'SGD' => 'Singapore Dollar',
						'SHP' => 'Saint Helenian Pound',
						'TJS' => 'Tajikistani Somoni',
						'SLL' => 'Sierra Leonean Leone',
						'SOS' => 'Somali Shilling',
						'SRD' => 'Surinamese Dollar',
						'STD' => 'São Tomé and Príncipe Dobra',
						'SVC' => 'Salvadoran Colón',
						'SZL' => 'Swazi Lilangeni',
						'THB' => 'Thai Baht',
						'TOP' => 'Tongan Paʻanga',
						'TRY' => 'Turkish Lira',
						'TTD' => 'Trinidad and Tobago Dollar',
						'TWD' => 'New Taiwan Dollar',
						'TZS' => 'Tanzanian Shilling',
						'UAH' => 'Ukrainian Hryvnia',
						'UGX' => 'Ugandan Shilling',
						'USD' => 'United States Dollar',
						'UYU' => 'Uruguayan Peso',
						'UZS' => 'Uzbekistani Som',
						'VND' => 'Vietnamese Đồng',
						'VUV' => 'Vanuatu Vatu',
						'WST' => 'Samoan Tala',
						'XAF' => 'Central African Cfa Franc',
						'XCD' => 'East Caribbean Dollar',
						'XOF' => 'West African Cfa Franc',
						'XPF' => 'Cfp Franc',
						'YER' => 'Yemeni Rial',
						'ZAR' => 'South African Rand',
						'ZMW' => 'Zambian Kwacha'
				    ),
				    'default'  => 'USD',
				),
				array(
				    'id'       => 'stripe-testmode',
				    'type'     => 'select',
				    'title'    => __('Stripe Test Mode', 'soho-hotel'), 
				    'subtitle' => '',
				    'desc'     => esc_html__( 'Stripe test mode allows you to test payments - you should set it to off when you publish your publish', 'soho-hotel' ),
				    'options'  => array(
				        'on' => 'On',
						'off' => 'Off'
				    ),
				    'false'  => 'Off',
				),
				array(
		            'id'       => 'stripe-test-secret-key',
		            'type'     => 'text',
		            'title'    => esc_html__( 'Test Secret Key', 'soho-hotel' ),
		            'subtitle' => '',
		            'desc'     => '',
		            'default'  => '',
		        ),
				array(
		            'id'       => 'stripe-test-publishable-key',
		            'type'     => 'text',
		            'title'    => esc_html__( 'Test Publishable Key', 'soho-hotel' ),
		            'subtitle' => '',
		            'desc'     => '',
		            'default'  => '',
		        ),
				array(
		            'id'       => 'stripe-live-secret-key',
		            'type'     => 'text',
		            'title'    => esc_html__( 'Live Secret Key', 'soho-hotel' ),
		            'subtitle' => '',
		            'desc'     => '',
		            'default'  => '',
		        ),
				array(
		            'id'       => 'stripe-live-publishable-key',
		            'type'     => 'text',
		            'title'    => esc_html__( 'Live Publishable Key', 'soho-hotel' ),
		            'subtitle' => '',
		            'desc'     => '',
		            'default'  => '',
		        )
		    )

		) );
	
		Redux::setSection( $opt_name, array(
		    'title'            => esc_html__( 'Cash Payments', 'soho-hotel' ),
		    'id'               => 'cash-payments',
		    'desc'             => '',
		    'customizer_width' => '400px',
		    'icon'             => 'el el-credit-card',
			'fields'           => array(
				array(
	                'id'       => 'disable_cash',
	                'type'     => 'checkbox',
	                'title'    => esc_html__( 'Disable Cash Payments', 'soho-hotel' ),
	                'subtitle' => '',
	                'desc'     => esc_html__( 'If you check this option cash payments will not be available to guests', 'soho-hotel' ),
	                'default'  => '0'// 1 = on | 0 = off
	            )
		    )

		) );
	
		Redux::setSection( $opt_name, array(
		    'title'            => esc_html__( 'Header', 'soho-hotel' ),
		    'id'               => 'page-header',
		    'desc'             => '',
		    'customizer_width' => '400px',
		    'icon'             => 'el el-align-justify',
			'fields'     => array(
		        array(
		            'id'       => 'page-header-image',
		            'type'     => 'media',
		            'title'    => esc_html__( 'Default Page Header Image', 'soho-hotel' ),
		            'desc'     => esc_html__( 'Displayed on all pages a header image is not set in the page options', 'soho-hotel' ),
		            'subtitle' => '',
		        ),
				array(
		            'id'       => 'page-not-found',
		            'type'     => 'media',
		            'title'    => esc_html__( '404 Page Not Found Background Image', 'soho-hotel' ),
		            'desc'     => esc_html__( 'Displayed on the 404 not found page', 'soho-hotel' ),
		            'subtitle' => '',
				)
			)
		) );
	
	Redux::setSection( $opt_name, array(
		'title'            => esc_html__( 'Footer', 'soho-hotel' ),
		'id'               => 'footer',
		'desc'             => '',
		'customizer_width' => '400px',
		'icon'             => 'el el-align-left',
		'fields'           => array(
			array(
				'id'       => 'footer-message',
				'type'     => 'text',
				'title'    => esc_html__( 'Footer Message', 'soho-hotel' ),
				'subtitle' => '',
				'desc'     => esc_html__( 'Text displayed in the bottom center of the site footer', 'soho-hotel' ),
				'default'  => '&copy; 2019 Soho Hotel. All Rights Reserved',
			),
			array(
				'id'       => 'footer-columns',
				'type'     => 'radio',
				'title'    => esc_html__( 'Footer Columns', 'soho-hotel' ),
				'subtitle' => '',
				'desc'     => '',
				'options'  => array(
					'1-col' => '1 Column',
					'2-col' => '2 Columns',
					'3-col' => '3 Columns',
					'4-col' => '4 Columns',
					'5-col' => '5 Columns',
					'6-col' => '6 Columns',
				),
				'default'  => '3-col'
			),
			array(
	            'id'       => 'footer-link-target',
	            'type'     => 'checkbox',
	            'title'    => esc_html__( 'Open footer links in new window/tab', 'soho-hotel' ),
	            'subtitle' => '',
	            'desc'     => '',
	            'default'  => '1'// 1 = on | 0 = off
	        ),
			array(
				'id'       => 'footer-link-text-1',
				'type'     => 'text',
				'title'    => esc_html__( 'Footer Link Text 1', 'soho-hotel' ),
				'subtitle' => '',
				'desc'     => '',
				'default'  => 'Home',
			),
			array(
				'id'       => 'footer-link-url-1',
				'type'     => 'text',
				'title'    => esc_html__( 'Footer Link URL 1', 'soho-hotel' ),
				'subtitle' => '',
				'desc'     => esc_html__( 'e.g. http://website.com', 'soho-hotel' ),
				'default'  => '#',
			),
			array(
				'id'       => 'footer-link-text-2',
				'type'     => 'text',
				'title'    => esc_html__( 'Footer Link Text 2', 'soho-hotel' ),
				'subtitle' => '',
				'desc'     => '',
				'default'  => 'About Us',
			),
			array(
				'id'       => 'footer-link-url-2',
				'type'     => 'text',
				'title'    => esc_html__( 'Footer Link URL 2', 'soho-hotel' ),
				'subtitle' => '',
				'desc'     => esc_html__( 'e.g. http://website.com', 'soho-hotel' ),
				'default'  => '#',
			),
			array(
				'id'       => 'footer-link-text-3',
				'type'     => 'text',
				'title'    => esc_html__( 'Footer Link Text 3', 'soho-hotel' ),
				'subtitle' => '',
				'desc'     => '',
				'default'  => 'Services',
			),
			array(
				'id'       => 'footer-link-url-3',
				'type'     => 'text',
				'title'    => esc_html__( 'Footer Link URL 3', 'soho-hotel' ),
				'subtitle' => '',
				'desc'     => esc_html__( 'e.g. http://website.com', 'soho-hotel' ),
				'default'  => '#',
			),
			array(
				'id'       => 'footer-link-text-4',
				'type'     => 'text',
				'title'    => esc_html__( 'Footer Link Text 4', 'soho-hotel' ),
				'subtitle' => '',
				'desc'     => '',
				'default'  => 'Booking',
			),
			array(
				'id'       => 'footer-link-url-4',
				'type'     => 'text',
				'title'    => esc_html__( 'Footer Link URL 4', 'soho-hotel' ),
				'subtitle' => '',
				'desc'     => esc_html__( 'e.g. http://website.com', 'soho-hotel' ),
				'default'  => '#',
			),
		)
	) );
	
	Redux::setSection( $opt_name, array(
	    'title'            => esc_html__( 'Logo', 'soho-hotel' ),
	    'id'               => 'logo',
	    'desc'             => '',
	    'customizer_width' => '400px',
	    'icon'             => 'el el-picture',
		'fields'           => array(
			array(
	            'id'       => 'logo-image',
	            'type'     => 'media',
	            'title'    => esc_html__( 'Logo Image', 'soho-hotel' ),
	            'desc'     => esc_html__( 'Add a logo image', 'soho-hotel' ),
	            'subtitle' => '',
			),
			array(
				'id'       => 'desktop-logo-image-top-margin',
				'type'     => 'text',
				'title'    => esc_html__( 'Desktop Logo Image Top Margin', 'soho-hotel' ),
				'subtitle' => '',
				'desc'     => esc_html__( 'Must be a px value, e.g. "10px"', 'soho-hotel' ),
				'default'  => '',
			),
			array(
				'id'       => 'desktop-logo-image-width',
				'type'     => 'text',
				'title'    => esc_html__( 'Desktop Logo Image Width', 'soho-hotel' ),
				'subtitle' => '',
				'desc'     => esc_html__( 'Must be a px or % value, e.g. "10px" or "10%"', 'soho-hotel' ),
				'default'  => '',
			),
			array(
				'id'       => 'desktop-logo-image-max-width',
				'type'     => 'text',
				'title'    => esc_html__( 'Desktop Logo Image Max Width', 'soho-hotel' ),
				'subtitle' => '',
				'desc'     => esc_html__( 'Must be a px or % value, e.g. "10px" or "10%"', 'soho-hotel' ),
				'default'  => '',
			),
			array(
				'id'       => 'desktop-sticky-nav-logo-image-top-margin',
				'type'     => 'text',
				'title'    => esc_html__( 'Desktop Sticky Navigation Logo Image Top Margin', 'soho-hotel' ),
				'subtitle' => '',
				'desc'     => esc_html__( 'Must be a px value, e.g. "10px"', 'soho-hotel' ),
				'default'  => '',
			),
			array(
				'id'       => 'desktop-sticky-nav-logo-image-width',
				'type'     => 'text',
				'title'    => esc_html__( 'Desktop Sticky Navigation Logo Image Width', 'soho-hotel' ),
				'subtitle' => '',
				'desc'     => esc_html__( 'Must be a px or % value, e.g. "10px" or "10%"', 'soho-hotel' ),
				'default'  => '',
			),
			array(
				'id'       => 'desktop-sticky-nav-logo-image-max-width',
				'type'     => 'text',
				'title'    => esc_html__( 'Desktop Sticky Navigation Logo Image Max Width', 'soho-hotel' ),
				'subtitle' => '',
				'desc'     => esc_html__( 'Must be a px or % value, e.g. "10px" or "10%"', 'soho-hotel' ),
				'default'  => '',
			),
			array(
				'id'       => 'mobile-logo-image-top-margin',
				'type'     => 'text',
				'title'    => esc_html__( 'Mobile Logo Image Top Margin', 'soho-hotel' ),
				'subtitle' => '',
				'desc'     => esc_html__( 'Must be a px value, e.g. "10px"', 'soho-hotel' ),
				'default'  => '',
			),
			array(
				'id'       => 'mobile-logo-image-width',
				'type'     => 'text',
				'title'    => esc_html__( 'Mobile Logo Image Width', 'soho-hotel' ),
				'subtitle' => '',
				'desc'     => esc_html__( 'Must be a px or % value, e.g. "10px" or "10%"', 'soho-hotel' ),
				'default'  => '',
			),
			array(
				'id'       => 'mobile-logo-image-max-width',
				'type'     => 'text',
				'title'    => esc_html__( 'Mobile Logo Image Max Width', 'soho-hotel' ),
				'subtitle' => '',
				'desc'     => esc_html__( 'Must be a px or % value, e.g. "10px" or "10%"', 'soho-hotel' ),
				'default'  => '',
			),
	    )

	) );

	Redux::setSection( $opt_name, array(
		'title'            => esc_html__( 'Colors', 'soho-hotel' ),
		'id'               => 'colors',
		'desc'             => '',
		'customizer_width' => '400px',
		'icon'             => 'el el-brush',
		'fields'     => array(
			array(
	            'id'       => 'main-color',
	            'type'     => 'color',
	            'title'    => esc_html__( 'Main Color', 'soho-hotel' ),
	            'subtitle' => '',
	            'default'  => '#b99470',
				'validate' => 'color',
	        ),
	        array(
	            'id'       => 'secondary-color',
	            'type'     => 'color',
	            'title'    => esc_html__( 'Secondary Background Color', 'soho-hotel' ),
	            'subtitle' => '',
	            'default'  => '#1c1c1c',
	            'validate' => 'color',
	        ),
			array(
	            'id'       => 'page-background-color',
	            'type'     => 'color',
	            'title'    => esc_html__( 'Page Background Color', 'soho-hotel' ),
	            'subtitle' => esc_html__( 'Note this is only visible if you\'re using the boxed layout', 'soho-hotel' ),
	            'default'  => '#666666',
				'validate' => 'color',
	        ),
			array(
	            'id'       => 'page-title-background-color',
	            'type'     => 'color',
	            'title'    => esc_html__( 'Page Title Background Color', 'soho-hotel' ),
	            'subtitle' => esc_html__( '', 'soho-hotel' ),
	            'default'  => '#f0f0f0',
				'validate' => 'color',
	        ),
			array(
	            'id'       => 'page-title-text-color',
	            'type'     => 'color',
	            'title'    => esc_html__( 'Page Title Text Color', 'soho-hotel' ),
	            'subtitle' => esc_html__( '', 'soho-hotel' ),
	            'default'  => '#424242',
				'validate' => 'color',
	        ),
			array(
	            'id'       => 'header-top-bar-background-color',
	            'type'     => 'color',
	            'title'    => esc_html__( 'Header Top Bar Background Color', 'soho-hotel' ),
	            'subtitle' => esc_html__( '', 'soho-hotel' ),
	            'default'  => 'transparent',
				'validate' => 'color',
	        ),
			array(
	            'id'       => 'header-top-bar-text-color',
	            'type'     => 'color',
	            'title'    => esc_html__( 'Header Top Bar Text Color', 'soho-hotel' ),
	            'subtitle' => esc_html__( '', 'soho-hotel' ),
	            'default'  => '#424242',
				'validate' => 'color',
	        ),
			
			
			
			
			
			
			
			
			
			
			
			
			
			
			
			
			
			array(
	            'id'       => 'header-top-bar-text-separator-color',
	            'type'     => 'color',
	            'title'    => esc_html__( 'Header Top Bar Text Separator Color', 'soho-hotel' ),
	            'subtitle' => esc_html__( '', 'soho-hotel' ),
	            'default'  => '#dddddd',
				'validate' => 'color',
	        ),
			
			
			
			array(
	            'id'       => 'header-top-bar-background-color-sticky-nav',
	            'type'     => 'color',
	            'title'    => esc_html__( 'Header Top Bar Background Color (Stick Navigation)', 'soho-hotel' ),
	            'subtitle' => esc_html__( '', 'soho-hotel' ),
	            'default'  => 'transparent',
				'validate' => 'color',
	        ),
			array(
	            'id'       => 'header-top-bar-text-color-sticky-nav',
	            'type'     => 'color',
	            'title'    => esc_html__( 'Header Top Bar Text Color (Stick Navigation)', 'soho-hotel' ),
	            'subtitle' => esc_html__( '', 'soho-hotel' ),
	            'default'  => '#424242',
				'validate' => 'color',
	        ),
			array(
	            'id'       => 'header-top-bar-text-separator-color-sticky-nav',
	            'type'     => 'color',
	            'title'    => esc_html__( 'Header Top Bar Text Separator Color (Stick Navigation)', 'soho-hotel' ),
	            'subtitle' => esc_html__( '', 'soho-hotel' ),
	            'default'  => '#dddddd',
				'validate' => 'color',
	        ),
			
			
			
			
			
			
			array(
	            'id'       => 'header-top-bar-text-color-homepage',
	            'type'     => 'color',
	            'title'    => esc_html__( 'Header Top Bar Text Color (Homepage)', 'soho-hotel' ),
	            'subtitle' => esc_html__( '', 'soho-hotel' ),
	            'default'  => '#424242',
				'validate' => 'color',
	        ),
			array(
	            'id'       => 'header-top-bar-text-separator-color-homepage',
	            'type'     => 'color',
	            'title'    => esc_html__( 'Header Top Bar Separator Color (Homepage)', 'soho-hotel' ),
	            'subtitle' => esc_html__( '', 'soho-hotel' ),
	            'default'  => '#dddddd',
				'validate' => 'color',
	        ),
			array(
	            'id'       => 'header-top-right-button-background-color',
	            'type'     => 'color',
	            'title'    => esc_html__( 'Header Top Right Button Background Color', 'soho-hotel' ),
	            'subtitle' => esc_html__( '', 'soho-hotel' ),
	            'default'  => '#b99470',
				'validate' => 'color',
	        ),
			array(
	            'id'       => 'header-top-right-button-text-color',
	            'type'     => 'color',
	            'title'    => esc_html__( 'Header Top Right Button Text Color', 'soho-hotel' ),
	            'subtitle' => esc_html__( '', 'soho-hotel' ),
	            'default'  => '#ffffff',
				'validate' => 'color',
	        ),
			array(
	            'id'       => 'logo-text-color',
	            'type'     => 'color',
	            'title'    => esc_html__( 'Logo Text Color', 'soho-hotel' ),
	            'subtitle' => esc_html__( '', 'soho-hotel' ),
	            'default'  => '#424242',
				'validate' => 'color',
	        ),
			array(
	            'id'       => 'main-menu-text-color',
	            'type'     => 'color',
	            'title'    => esc_html__( 'Main Menu Text Color', 'soho-hotel' ),
	            'subtitle' => esc_html__( '', 'soho-hotel' ),
	            'default'  => '#424242',
				'validate' => 'color',
	        ),
			array(
	            'id'       => 'logo-text-color-sticky-nav',
	            'type'     => 'color',
	            'title'    => esc_html__( 'Logo Text Color (Stick Navigation)', 'soho-hotel' ),
	            'subtitle' => esc_html__( '', 'soho-hotel' ),
	            'default'  => '#424242',
				'validate' => 'color',
	        ),
			array(
	            'id'       => 'main-menu-text-color-sticky-nav',
	            'type'     => 'color',
	            'title'    => esc_html__( 'Main Menu Text Color (Stick Navigation)', 'soho-hotel' ),
	            'subtitle' => esc_html__( '', 'soho-hotel' ),
	            'default'  => '#424242',
				'validate' => 'color',
	        ),
			array(
	            'id'       => 'logo-text-color-homepage',
	            'type'     => 'color',
	            'title'    => esc_html__( 'Logo Text Color (Homepage)', 'soho-hotel' ),
	            'subtitle' => esc_html__( '', 'soho-hotel' ),
	            'default'  => '#424242',
				'validate' => 'color',
	        ),
			array(
	            'id'       => 'main-menu-text-color-homepage',
	            'type'     => 'color',
	            'title'    => esc_html__( 'Main Menu Text Color (Homepage)', 'soho-hotel' ),
	            'subtitle' => esc_html__( '', 'soho-hotel' ),
	            'default'  => '#424242',
				'validate' => 'color',
	        ),
			array(
	            'id'       => 'footer-background-color',
	            'type'     => 'color',
	            'title'    => esc_html__( 'Footer Background Color', 'soho-hotel' ),
	            'subtitle' => esc_html__( '', 'soho-hotel' ),
	            'default'  => '#1c1c1c',
				'validate' => 'color',
	        ),
			array(
	            'id'       => 'footer-text-color',
	            'type'     => 'color',
	            'title'    => esc_html__( 'Footer Text Color', 'soho-hotel' ),
	            'subtitle' => esc_html__( '', 'soho-hotel' ),
	            'default'  => '#ffffff',
				'validate' => 'color',
	        ),
			array(
	            'id'       => 'footer-text-color',
	            'type'     => 'color',
	            'title'    => esc_html__( 'Footer Text Color', 'soho-hotel' ),
	            'subtitle' => esc_html__( '', 'soho-hotel' ),
	            'default'  => '#ffffff',
				'validate' => 'color',
	        ),
			array(
	            'id'       => 'footer-bottom-bar-background-color',
	            'type'     => 'color',
	            'title'    => esc_html__( 'Footer Bottom Bar Background Color', 'soho-hotel' ),
	            'subtitle' => esc_html__( '', 'soho-hotel' ),
	            'default'  => '#b99470',
				'validate' => 'color',
	        ),
			array(
	            'id'       => 'footer-bottom-bar-text-color',
	            'type'     => 'color',
	            'title'    => esc_html__( 'Footer Bottom Bar Text Color', 'soho-hotel' ),
	            'subtitle' => esc_html__( '', 'soho-hotel' ),
	            'default'  => '#ffffff',
				'validate' => 'color',
	        ),
			array(
	            'id'       => 'booking-form-background-color',
	            'type'     => 'color',
	            'title'    => esc_html__( 'Booking Form Background Color', 'soho-hotel' ),
	            'subtitle' => esc_html__( '', 'soho-hotel' ),
	            'default'  => '#1c1c1c',
				'validate' => 'color',
	        ),
			array(
	            'id'       => 'booking-form-text-color',
	            'type'     => 'color',
	            'title'    => esc_html__( 'Booking Form Text Color', 'soho-hotel' ),
	            'subtitle' => esc_html__( '', 'soho-hotel' ),
	            'default'  => '#ffffff',
				'validate' => 'color',
	        ),
			array(
	            'id'       => 'booking-form-price-border-color',
	            'type'     => 'color',
	            'title'    => esc_html__( 'Booking Form Price Border Color', 'soho-hotel' ),
	            'subtitle' => esc_html__( 'Only visible on the accommodation single page booking form, the border is displayed around the quoted room price', 'soho-hotel' ),
	            'default'  => '#494949',
				'validate' => 'color',
	        ),
			array(
	            'id'       => 'booking-form-button-background-color',
	            'type'     => 'color',
	            'title'    => esc_html__( 'Booking Form Button Background Color', 'soho-hotel' ),
	            'subtitle' => esc_html__( '', 'soho-hotel' ),
	            'default'  => '#b99470',
				'validate' => 'color',
	        ),
			array(
	            'id'       => 'booking-form-button-text-color',
	            'type'     => 'color',
	            'title'    => esc_html__( 'Booking Form Button Text Color', 'soho-hotel' ),
	            'subtitle' => esc_html__( '', 'soho-hotel' ),
	            'default'  => '#ffffff',
				'validate' => 'color',
	        ),
			array(
	            'id'       => 'datepicker-background-color',
	            'type'     => 'color',
	            'title'    => esc_html__( 'Datepicker Background Color', 'soho-hotel' ),
	            'subtitle' => esc_html__( '', 'soho-hotel' ),
	            'default'  => '#1c1c1c',
				'validate' => 'color',
	        ),
			array(
	            'id'       => 'datepicker-day-background-color',
	            'type'     => 'color',
	            'title'    => esc_html__( 'Datepicker Day Background Color', 'soho-hotel' ),
	            'subtitle' => esc_html__( '', 'soho-hotel' ),
	            'default'  => '#424242',
				'validate' => 'color',
	        ),
			array(
	            'id'       => 'datepicker-selected-date-background-color',
	            'type'     => 'color',
	            'title'    => esc_html__( 'Datepicker Selected Background Color', 'soho-hotel' ),
	            'subtitle' => esc_html__( '', 'soho-hotel' ),
	            'default'  => '#b99470',
				'validate' => 'color',
	        ),
			array(
	            'id'       => 'datepicker-selected-date-background-color-2',
	            'type'     => 'color',
	            'title'    => esc_html__( 'Datepicker Selected Background Color 2', 'soho-hotel' ),
	            'subtitle' => esc_html__( '', 'soho-hotel' ),
	            'default'  => '#85705c',
				'validate' => 'color',
	        ),
			array(
	            'id'       => 'datepicker-text-color',
	            'type'     => 'color',
	            'title'    => esc_html__( 'Datepicker Text Color', 'soho-hotel' ),
	            'subtitle' => esc_html__( '', 'soho-hotel' ),
	            'default'  => '#ffffff',
				'validate' => 'color',
	        ),
			array(
	            'id'       => 'datepicker-unavailable-date-background-color',
	            'type'     => 'color',
	            'title'    => esc_html__( 'Datepicker Unavailable Date Background Color', 'soho-hotel' ),
	            'subtitle' => esc_html__( '', 'soho-hotel' ),
	            'default'  => '#292929',
				'validate' => 'color',
	        ),
			array(
	            'id'       => 'datepicker-unavailable-date-text-color',
	            'type'     => 'color',
	            'title'    => esc_html__( 'Datepicker Unavailable Date Text Color', 'soho-hotel' ),
	            'subtitle' => esc_html__( '', 'soho-hotel' ),
	            'default'  => '#7b7b7b',
				'validate' => 'color',
	        ),
			array(
	            'id'       => 'datepicker-border-color',
	            'type'     => 'color',
	            'title'    => esc_html__( 'Datepicker Border Color', 'soho-hotel' ),
	            'subtitle' => esc_html__( '', 'soho-hotel' ),
	            'default'  => '#424242',
				'validate' => 'color',
	        )
		)
	) );

	Redux::setSection( $opt_name, array(
	    'title'            => esc_html__( 'Fonts', 'soho-hotel' ),
	    'id'               => 'fonts',
	    'desc'             => '',
	    'customizer_width' => '400px',
	    'icon'             => 'el el-font',
		'fields'     => array(
			array(
	            'id'       => 'google_font_name_1',
	            'type'     => 'text',
	            'title'    => esc_html__( 'Font Family 1 (Used For Titles)', 'soho-hotel' ),
	            'subtitle' => '',
	            'desc'     => esc_html__( "e.g. 'Cormorant', serif", 'soho-hotel' ),
	            'default'  => "'Cormorant', serif",
	        ),
			array(
	            'id'       => 'google_font_url_1',
	            'type'     => 'textarea',
	            'title'    => esc_html__( 'Font URL 1', 'soho-hotel' ),
	            'subtitle' => '',
	            'desc'     => esc_html__( "Only required if you're using Google Fonts or similar, e.g. Cormorant:400,400i,500,500i", 'soho-hotel' ),
	            'default'  => "Cormorant:400,400i,500,500i",
	        ),	
			array(
	            'id'       => 'google_font_name_2',
	            'type'     => 'text',
	            'title'    => esc_html__( 'Font Family 2 (Used For Body)', 'soho-hotel' ),
	            'subtitle' => '',
	            'desc'     => esc_html__( "e.g. 'Open Sans', sans-serif", 'soho-hotel' ),
	            'default'  => "'Open Sans', sans-serif",
	        ),
			array(
	            'id'       => 'google_font_url_2',
	            'type'     => 'textarea',
	            'title'    => esc_html__( 'Font URL 2', 'soho-hotel' ),
	            'subtitle' => '',
	            'desc'     => esc_html__( "Only required if you're using Google Fonts or similar, e.g. Open+Sans:400,400i", 'soho-hotel' ),
	            'default'  => "Open+Sans:400,400i",
	        ),
		)
	) );
	
	Redux::setSection( $opt_name, array(
	    'title'            => esc_html__( 'Custom JS', 'soho-hotel' ),
	    'id'               => 'custom-js',
	    'desc'             => '',
	    'customizer_width' => '400px',
	    'icon'             => 'el el-edit',

		'fields'     => array(
	        array(
	            'id'       => 'custom_js',
	            'type'     => 'textarea',
	            'title'    => esc_html__( 'Custom JS', 'soho-hotel' ),
	            'subtitle' => '',
	            'desc'     => esc_html__( 'Add your own custom JS to the theme', 'soho-hotel' ),
	            'default'  => '',
			),
		)
	) );